//
//  MCReportAttributesRegistry.h
//  MCReporting
//
//  Created by Alykhan Jetha on 10/11/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface MCReportAttributesRegistry : NSObject {
	NSMutableArray *handlers;
	NSMutableDictionary *config;
	NSArray *validTemplateFileExtensions;
	
	NSString *lazyLoadPListPath;
	BOOL loaded;
	
	NSMutableDictionary *reportKeysByEntity;
	NSMutableDictionary *behaviorKeys;
	NSMutableArray *entitiesForVisualQuery;
	NSArray *entities;
	NSArray *entityDescriptionsForDocumentation;
	
	NSMutableArray *namedImages;
	
	NSMutableDictionary *liveTableReplacementClassnames;
	NSString *logoPathKeyPath;
	NSString *logoDataKeyPath;
	
	NSArray *validEntityKinds;
	
	
	NSString *sharedImagesBundleIdentifier; // the bundle in which the shared images are located
	
}

@property (retain) NSString *sharedImagesBundleIdentifier;
@property (retain) NSArray *entities;

+ (MCReportAttributesRegistry *)defaultReportAttributesRegistry;

+ (void)registerReportKeysConfigFilePath:(NSString *)aPath;

- (void)setReportKeysConfigFilePath:(NSString *)aPath;

- (NSMutableArray *)handlers;
- (void)setHandlers:(NSMutableArray *)aHandlers;

//- (void)addReportTemplateFileExtension:(NSString *)anExtension;
//- (NSArray *)validTemplateFileExtensions;

- (NSArray *)reportKeysForEntityOrClassname:(NSString *)aName;
- (NSArray *)toManyReportKeysForEntityOrClassname:(NSString *)aName;
- (NSArray *)toOneReportKeysForEntityOrClassname:(NSString *)aName;

- (NSMutableDictionary *)reportKeysByEntity;
- (void)setReportKeysByEntity:(NSMutableDictionary *)aReportKeysByEntity;

- (NSMutableDictionary *)behaviorKeys;
- (void)setBehaviorKeys:(NSMutableDictionary *)aBehaviorKeys;

- (NSMutableArray *)namedImages;
- (void)setNamedImages:(NSMutableArray *)aNamedImages;

- (NSMutableArray *)entitiesForVisualQuery;
- (void)setEntitiesForVisualQuery:(NSMutableArray *)anEntitiesForVisualQuery;
- (NSArray *)availableEntitiesForVisualQuery;


- (NSArray *)areasForBehaviorKey:(NSString *)aKey;

// make sure the config is loaded
- (NSArray *)availableNamedImages;

- (NSArray *)validEntityKinds;

// Returns an array of MCReportAttributesEntityDescription. Lazily created on first call.
- (NSArray *)entityDescriptionsForDocumentation;

// replacement rules for data and header cell classname in nstableview or outlineview
- (NSMutableDictionary *)liveTableReplacementClassnames;
- (void)setLiveTableReplacementClassnames:(NSMutableDictionary *)aLiveTableReplacementClassnames;
- (void)setLiveTableReplacementClassname:(id)aLiveTableReplacementClassname forKey:(id)aKey;
- (void)removeLiveTableReplacementClassnameForKey:(id)aKey;


// i.e. databaseUserDefaults.BILogoPath
- (NSString *)logoPathKeyPath;
- (void)setLogoPathKeyPath:(NSString *)aLogoPathKeyPath;

// expects a keypath that returns a NSData or NSImage
- (NSString *)logoDataKeyPath;
- (void)setLogoDataKeyPath:(NSString *)aValue;

@end
